# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy, os

from pathlib import Path
from typing import List, Union

from .utils.blender import config_parent_dir

ResourceType = Union[bpy.types.Object, bpy.types.Collection, bpy.types.Material, bpy.types.NodeGroup]
ResourceTypes = List[ResourceType]

config_dir = os.path.join(config_parent_dir(), '.asset-wizard-pro')
config = os.path.join(config_dir, 'config.json')
dev_config = os.path.join(config_dir, 'config-dev.json')
key_map_config = os.path.join(config_dir, 'keymap.json')
asset_cache_file = os.path.join(config_dir, 'asset_cache_v2.json')
asset_cache_dir = os.path.join(config_dir, 'previews')
asset_cache_base_path = config_dir
panel_name = 'Asset Wizard Pro'

texture_pack_options = [
    ( 'ALL', 'Pack ALL Textures', 'All used Textures are packed into Library' ),
    ( 'NONE', 'Pack NO Textures', 'No Textures are packed into Library' ),
    ( 'SEL', 'Select in Dialog', 'Open Dialog to select Textures to pack into the Library' ),
]
