# Copyright (C) 2025 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import dataclasses, json

from dataclasses import dataclass
from typing import List

@dataclass
class RenderPreviewSettings:
    blend_file: str
    image_file: str
    mode: str
    name: str
    engine: str
    samples: str
    device: str
    denoiser: str
    image_format: str
    size: int

    def to_js(self) -> str:
        return json.dumps(dataclasses.asdict(self))

    @staticmethod
    def from_js(js: str) -> 'RenderPreviewSettings':
        j = json.loads(js)
        return RenderPreviewSettings(
            j['blend_file'],
            j['image_file'],
            j['mode'],
            j['name'],
            j['engine'],
            j['samples'],
            j['device'],
            j['denoiser'],
            j['image_format'],
            j['size']
        )
    

@dataclass
class SettingsUpdateSettings:
    reimport_blend: str
    image_file: str
    mode: str
    name: str 
    catalog: str
    description: str
    author: str
    tags: List[str]
    extra_tag: str
    auto_place: bool
    pack_images: List[str]
    image_cleanup: bool
    relative_paths: bool

    def to_js(self) -> str:
        return json.dumps(dataclasses.asdict(self))

    @staticmethod
    def from_js(js: str) -> 'SettingsUpdateSettings':
        j = json.loads(js)
        return SettingsUpdateSettings(
            j['reimport_blend'],
            j['image_file'],
            j['mode'],
            j['name'],
            j['catalog'],
            j['description'],
            j['author'],
            j['tags'],
            j['extra_tag'],
            j['auto_place'],
            j['pack_images'],
            j['image_cleanup'],
            j['relative_paths'],
        )   
    
