# Copyright (C) 2023 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from ..properties import Properties
from ..utils.blender import is_file_saved

from ..operators.update_local import ASSET_OT_update_local
from ..operators.multi_purpose import ASSET_OT_multi_purpose

def asset_browser_header(self, context: bpy.types.Context):
    """
    Add buttons to asset browser header to recreate local asset prview images.
    """
    from bpy_extras.asset_utils import SpaceAssetInfo

    space_data = context.space_data
    if SpaceAssetInfo.is_asset_browser(space_data):
        layout = self.layout # type: bpy.types.UILayout

        props = Properties.get()

        layout.separator()
        r = layout.row(align=True)
        r2 = r.row(align=True)
        r2.enabled = is_file_saved()
        ASSET_OT_update_local.create_ui(r2)
        ASSET_OT_multi_purpose.create_ui_auto_place(r, props.auto_place_padding)
        r.prop(props, 'auto_place_padding')


def add_asset_browser_header():
    bpy.types.FILEBROWSER_HT_header.append(asset_browser_header)


def remove_asset_browser_header():
    bpy.types.FILEBROWSER_HT_header.remove(asset_browser_header)       
