# Copyright (C) 2023 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from ..registries.icons_registry import IconsRegistry


def view3d_editor_header(self, _: bpy.types.Context):
    """
    Add useful tools to 3d view.
    """
    layout = self.layout # type: bpy.types.UILayout
    r = layout.row(align=True)
    r.menu('VIEW3D_MT_awp_assets_import_menu', text='', icon_value=IconsRegistry.get_icon('awp-logo-mini'))


def add_view3d_header():
    bpy.types.VIEW3D_MT_editor_menus.append(view3d_editor_header)


def remove_view3d_header():
    bpy.types.VIEW3D_MT_editor_menus.remove(view3d_editor_header)


def set_view3d_header(enable: bool):
    if enable:
        remove_view3d_header()
        add_view3d_header()
    else:
        remove_view3d_header()
