# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Operator, UILayout

from .export_assets import ASSET_OT_export
from ..properties import Properties
from ..registries.resource_selection_registry import ResourceSelectionRegistry
from .ui_select import ASSET_OT_ui_select


class ASSET_OT_export_collections(Operator):
    """
    Show list of available collections to let the
    user select which should be exported.
    """
    bl_idname = 'awp.export_collections'
    bl_label = ''
    bl_description = ''
    bl_options = {'REGISTER'}

    def execute(self, context: bpy.types.Context):
        if ResourceSelectionRegistry.get().selected():
            ASSET_OT_export.call_with_resource_selection(Properties.get().object_collection_section)
        return {'FINISHED'}    


    def draw(self, context: bpy.types.Context):
        self.layout.ui_units_x = 40
        a = self.layout.column(align=True)
        a.label(text='Select Collections to export:')
        for rs in ResourceSelectionRegistry.get().all():
            r = a.row(align=True)
            ASSET_OT_ui_select.create_ui(r, 'CHECKBOX_HLT' if rs.selected else 'CHECKBOX_DEHLT', '', rs.selected, 'TOGGLE_RESOURCE', rs.resource.name)
            r.label(text=f'  {rs.resource.name}')

    
    def invoke(self, context: bpy.types.Context, event):
        ResourceSelectionRegistry.get().load(bpy.data.collections)
        return context.window_manager.invoke_props_dialog(self)


    @staticmethod
    def create_ui(l: UILayout):
        l.operator(ASSET_OT_export_collections.bl_idname, text='Export Collections', icon='OUTLINER_OB_GROUP_INSTANCE')
