# Copyright (C) 2023 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

from bpy.types import Context, Operator, UILayout
from ..registries.resource_lists_registry import ResourceListsRegistry


class ASSET_OT_refresh_res_lists(Operator):
    """
    Refresh asset cache from libraries.
    """
    bl_idname = 'awp.refresh_res_lists'
    bl_label = 'Update Information from Library (may take a while)'
    bl_description = 'Refresh Asset Cache'
    bl_options = {'REGISTER'}


    def execute(self, context: Context):
        ResourceListsRegistry.get().update(True)
        self.report({'INFO'}, 'Asset Cache updated')
        return {'FINISHED'}


    def invoke(self, context, event):
        return context.window_manager.invoke_confirm(self, event)


    @staticmethod
    def create_ui(l: UILayout, text: str = ''):
        l.operator(ASSET_OT_refresh_res_lists.bl_idname, text=text, icon='FILE_REFRESH')
