# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Operator, UILayout
from bpy.props import StringProperty

from ..utils.blender import DropNodeOperator
from ..registries.icons_registry import IconsRegistry


class ASSET_OT_std_node_drop(Operator, DropNodeOperator):
    """
    Import node.
    """
    bl_idname = 'awp.std_node_drop'
    bl_label = ''
    bl_description = ''
    bl_options = {'REGISTER', 'UNDO'}


    system: StringProperty() # type: ignore
    type: StringProperty() # type: ignore
    op: StringProperty() # type: ignore
    bt: StringProperty() # type: ignore
    tooltip: StringProperty() # type: ignore


    @classmethod
    def description(cls, context, properties):
        return properties.tooltip


    def execute(self, context: bpy.types.Context):
        settings = []
        if self.op: 
            settings.append({ 
                'name': 'operation',
                'value': self.op
            })
        if self.bt:
            settings.append({ 
                'name': 'blend_type',
                'value': self.bt
            })

        if settings:
            bpy.ops.node.add_node(
                type=f"{self.system}Node{self.type}", 
                use_transform=True,
                settings=settings
            )
        else:
            bpy.ops.node.add_node(
                type=f"{self.system}Node{self.type}", 
                use_transform=True,
            )

        return{'FINISHED'}


    @staticmethod
    def create_ui(l: UILayout, system: str, type: str, ope: str, bt: str, text: str, icon: str, tooptip: str, color: str = None):
        op = None # type: ASSET_OT_std_node_drop
        if color and IconsRegistry.colored_icon_exists(icon, color):
            op = l.operator(ASSET_OT_std_node_drop.bl_idname, text=text, icon_value=IconsRegistry.get_colored_icon(icon, color))         
        else:
            op = l.operator(ASSET_OT_std_node_drop.bl_idname, text=text, icon=icon if icon else 'NONE')
        op.system = system
        op.type = type
        op.op = ope
        op.bt = bt
        op.tooltip = tooptip
