# Copyright (C) 2023 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Panel

from ..constants import panel_name
from ..preferences import PreferencesPanel
from ..properties import Properties
from ..utils.tools import local_addon_info

from ..registries.resource_lists_registry import ResourceListsRegistry
from ..operators.import_3d_object import ASSET_OT_import_3d_object
from ..operators.import_3d_material import ASSET_OT_import_3d_material, MaterialImportMode
from ..operators.multi_purpose import ASSET_OT_multi_purpose
from ..operators.object_placer import ASSET_OT_object_placer
from ..operators.refresh_res_list import ASSET_OT_refresh_res_lists

class VIEW3D_PT_awp_import_3d_panel(Panel):
    """
    Various tools in 3D View
    """
    bl_label = 'Import and Place'
    bl_idname = 'VIEW3D_PT_awp_import_3d_panel'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = panel_name


    @classmethod
    def poll(cls, _):
        return local_addon_info.vl()    


    def draw(self, context: bpy.types.Context):
        prefs = PreferencesPanel.get()
        props = Properties.get()

        c = self.layout.column(align=True)
        if ResourceListsRegistry.get().col_or_object_catalogs():
            c.prop(props, 'import_3d_catalogs_objects', text='')
            if props.import_3d_catalogs_objects:
                c.template_icon_view(
                    props, 
                    'import_3d_objects', 
                    show_labels=True, 
                    scale=prefs.view3d_preview_scale, 
                    scale_popup=prefs.view3d_preview_scale_popup
                )
                r = c.row(align=True)
                s = r.split(factor=0.5, align=True)
                if props.import_3d_objects:
                    asset = ResourceListsRegistry.get().asset_by_uuid(props.import_3d_objects)
                    if asset:
                        is_collection = asset.type == 'Collection'
                        ASSET_OT_import_3d_object.create_ui(s, asset, True, is_collection)
                        ASSET_OT_import_3d_object.create_ui(s, asset, False, is_collection)
                        ASSET_OT_multi_purpose.create_ui_open_asset(r, asset.blend)
            else:
                c.label(text='Catalog is empty')
        else:
            c.label(text='No objects found, consider rescan')

        c.separator()
        if ResourceListsRegistry.get().materials_catalogs():
            c.prop(props, 'import_3d_catalogs_materials', text='')
            c.template_icon_view(
                props, 
                'import_3d_materials', 
                show_labels=True, 
                scale=prefs.view3d_preview_scale, 
                scale_popup=prefs.view3d_preview_scale_popup
            )
            r = c.row(align=True)
            if props.import_3d_materials:
                asset = ResourceListsRegistry.get().asset_by_uuid(props.import_3d_materials)
                if asset:
                    """
                    s = r.split(factor=0.33, align=True)
                    s.context_pointer_set('import_mode_valid', ASSET_OT_import_3d_material.mode_valid(MaterialImportMode.CURRENT, context))
                    ASSET_OT_import_3d_material.create_ui(s, asset, False, MaterialImportMode.CURRENT)
                    s = s.split(factor=0.5, align=True)
                    s.context_pointer_set('import_mode_valid', ASSET_OT_import_3d_material.mode_valid(MaterialImportMode.SELECTED, context))
                    ASSET_OT_import_3d_material.create_ui(s, asset, False, MaterialImportMode.SELECTED)
                    s.context_pointer_set('import_mode_valid', ASSET_OT_import_3d_material.mode_valid(MaterialImportMode.CURRENT_SLOT, context))
                    ASSET_OT_import_3d_material.create_ui(s, asset, False, MaterialImportMode.CURRENT_SLOT)
                    """
                    s = r.split(factor=0.5, align=True)
                    s2 = s.split(factor=0.5, align=True)
                    if ASSET_OT_import_3d_material.mode_valid(MaterialImportMode.CURRENT, context):
                        ASSET_OT_import_3d_material.create_ui(s2, asset, props.material_import_linked, props.material_import_prefer_existing, MaterialImportMode.CURRENT)
                    else: s2.label(text='')
                    if ASSET_OT_import_3d_material.mode_valid(MaterialImportMode.SELECTED, context):
                        ASSET_OT_import_3d_material.create_ui(s2, asset, props.material_import_linked, props.material_import_prefer_existing, MaterialImportMode.SELECTED)
                    else: s2.label(text='')
                    s2 = s.split(factor=0.5, align=True)
                    if ASSET_OT_import_3d_material.mode_valid(MaterialImportMode.CURRENT_SLOT, context):
                        ASSET_OT_import_3d_material.create_ui(s2, asset, props.material_import_linked, props.material_import_prefer_existing, MaterialImportMode.CURRENT_SLOT)
                    else: s2.label(text='')
                    ASSET_OT_multi_purpose.create_ui_open_asset(r, asset.blend)

                    s3 = s2.split(factor=0.5, align=True)
                    s3.prop(
                        props, 
                        'material_import_linked', 
                        text='', 
                        toggle=True, 
                        icon='DECORATE_LIBRARY_OVERRIDE' if props.material_import_linked else 'ADD'
                    )
                    s3.prop(
                        props, 
                        'material_import_prefer_existing', 
                        text='', 
                        toggle=True, 
                        icon='PACKAGE' if props.material_import_prefer_existing else 'ASSET_MANAGER'
                    )

        else:
            c.label(text='No materials found, consider rescan')            

        c.separator()
        ASSET_OT_refresh_res_lists.create_ui(c, 'Refresh Cache')

        if context.active_object:
            c.separator()
            c.label(text='Viewport Tools', icon='VIEW3D')
            if context.active_object.library:
                ASSET_OT_multi_purpose.create_ui_library_override(c)
            else:
                ASSET_OT_object_placer.create_ui(c, props.replace_mode, props.place_quick, props.place_create_copy, props.place_linked_copy, props.place_auto_parent)
                r = c.row(align=True)
                r.prop(props, 'replace_mode', toggle=True, icon='PIVOT_ACTIVE', text='')
                r.prop(props, 'place_quick', toggle=True, icon='TIME', text='')
                r.prop(props, 'place_create_copy', toggle=True, icon='DUPLICATE', text='')
                if props.place_create_copy:
                    r.prop(props, 'place_linked_copy', toggle=True, icon='LIBRARY_DATA_DIRECT', text='')
                r.prop(props, 'place_auto_parent', toggle=True, icon='CONSTRAINT', text='')
