# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Panel

from ..constants import panel_name
from ..awp.ui import trial_panel
from ..utils.tools import local_addon_info
from ..utils.blender import is_valid_node_space


class NODE_PT_awp_info_shader_panel(Panel):
    """
    Show info panel.
    """
    bl_label = 'Info'
    bl_idname = 'NODE_PT_awp_info_shader_panel'
    bl_space_type = 'NODE_EDITOR'
    bl_region_type = 'UI'
    bl_category = panel_name


    @classmethod
    def poll(cls, context):
        return is_valid_node_space(context, ['ShaderNodeTree']) and not local_addon_info.vl()


    def draw(self, context: bpy.types.Context):
        trial_panel(self.layout)
