# Copyright (C) 2024 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import os

from ..utils.io import run_blender


def update_asset_database(blend_file: str, asset_cache_path: str, lib: str):
    """
    Scans all assets in the given blend and updates the asset cache information.
    Besides that, exports (missing) preview images to use in the UI.
    """
    run_blender([
        '--background',
        '--factory-startup',
        blend_file,
        '--python',
        os.path.join(os.path.dirname(__file__), 'extract_assets.py'),
        '--',
        asset_cache_path,
        lib,
    ])
