# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Operator, UILayout
from bpy.props import StringProperty

from ..registries.image_packer_registry import ImagePackerRegistry
from ..registries.resource_selection_registry import ResourceSelectionRegistry


class ASSET_OT_ui_select(Operator):
    """
    Used to toggle selection of packed images.
    """
    bl_idname = 'awp.ui_select'
    bl_label = ''
    bl_description = ''
    bl_options = {'REGISTER'}


    mode: StringProperty() # type: ignore
    element_name: StringProperty() # type: ignore


    @classmethod
    def description(cls, context, properties):
        return {
            'ALL': 'Pack all Images',
            'NONE': 'Pack no Images',
            'TOGGLE': 'Toggle pack Option',
            'INFO': 'Toggle Info Display',
            'TOGGLE_RESOURCE': 'Toggle Export'
        }.get(properties.mode, '??')


    def execute(self, context: bpy.types.Context):
        if self.mode == 'ALL': ImagePackerRegistry.get().set_all(True)
        elif self.mode == 'NONE': ImagePackerRegistry.get().set_all(False)
        elif self.mode == 'TOGGLE': ImagePackerRegistry.get().toggle(self.element_name)
        elif self.mode == 'INFO': ImagePackerRegistry.get().toggle_info(self.element_name)
        elif self.mode == 'TOGGLE_RESOURCE': ResourceSelectionRegistry.get().toggle(self.element_name)
        
        return {'FINISHED'}


    @staticmethod
    def create_ui(l: UILayout, icon: str, text: str, depress: bool, mode: str, element_name: str):
        op = l.operator(ASSET_OT_ui_select.bl_idname, icon=icon, text=text, depress=depress) # type: ASSET_OT_ui_select
        op.mode = mode
        op.element_name = element_name
        