# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Panel

from ..constants import panel_name
from ..properties import Properties
from ..awp.ui import export_panel
from ..utils.tools import local_addon_info
from ..operators.export_collections import ASSET_OT_export_collections


class VIEW3D_PT_awp_export_3d_panel(Panel):
    """
    Export objects + materials, shown in 3DView side panel.
    """
    bl_label = 'Export'
    bl_idname = 'VIEW3D_PT_awp_export_3d_panel'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = panel_name


    @classmethod
    def poll(cls, _):
        return local_addon_info.vl()


    def draw(self, context: bpy.types.Context):
        props = Properties.get()
        res = []
        o = context.active_object
        if o:
            res.append(('OBJECT', 'OBJECT_DATA', 'Object', o.name))
        if context.selected_objects:
            res.append(('SELECTED_OBJECTS', 'RESTRICT_SELECT_OFF', 'Selected Objects', ''))

        if res:
            c = export_panel(self.layout, res, props.object_collection_section, 'OC')
            if c:
                if bpy.data.collections:
                    ASSET_OT_export_collections.create_ui(c)
            
                c.separator()
                c.prop(props, 'texture_pack_mode', text='')
        else:
            self.layout.box().label(text='Nothing to export', icon='ERROR')
