# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Panel

from ..constants import panel_name
from ..awp.ui import trial_panel
from ..utils.tools import local_addon_info


class VIEW3D_PT_awp_info_3d_panel(Panel):
    """
    Show info panel.
    """
    bl_label = 'Info'
    bl_idname = 'VIEW3D_PT_awp_info_3d_panel'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = panel_name


    @classmethod
    def poll(cls, _):
        return not local_addon_info.vl()


    def draw(self, context: bpy.types.Context):
        trial_panel(self.layout)
