# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import os

from .utils.blender import config_parent_dir

ROOT_DIR = os.path.dirname(os.path.abspath(__file__))
CONFIG_DIR = os.path.join(config_parent_dir(), '.shader-node-wizard')


def config_file(filename: str) -> str:
    return os.path.join(CONFIG_DIR, filename)


def snw_rel_path(*paths):
    """
    Return path relative to SNW root.
    """
    return os.path.join(ROOT_DIR, *paths)
    

uv_mappings = [
    ( 'UV', 'UV', 'Default UV Mapping', 'UV', 0 ),
    ( 'LBOX', 'Local', 'Local Box/Triplanar Mapping (Object)', 'PIVOT_BOUNDBOX', 1 ),
    ( 'GENBOX', 'Gen', 'Global Box/Triplanar Mapping (Generated)', 'ORIENTATION_VIEW', 3 ),
    ( 'GBOX', 'Global', 'World Position Box/Triplanar Mapping', 'ORIENTATION_GLOBAL', 2 ),
]

image_interpolations = [
    ( 'Linear', 'Linear', 'Linear Interpolation', 'IPO_LINEAR', 0 ),
    ( 'Closest', 'Closest', 'No Interpolation (Sample closest Texel)', 'IPO_CONSTANT', 1 ),
    ( 'Cubic', 'Cubic', 'Cubic Interpolation', 'IPO_CUBIC', 2 ),
    ( 'Smart', 'Smart', 'Bicubic when magnifying, else bilinear (OSL only)', 'IPO_EXPO', 3 ),
]    
