# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Menu

from ..properties import Properties
from ..operators.support_assign_material import UI_OT_support_assign_material
from ..operators.support_fix_eevee_transparency import UI_OT_support_fix_eevee_transparency
from ..operators.support_arrange_nodes import UI_OT_support_arrange_nodes


class NODE_MT_snw_material_assign(Menu):
    bl_idname = 'NODE_MT_snw_material_assign'
    bl_label = 'Assign Material'


    @classmethod
    def description(cls, context: bpy.types.Context, _):
        if context.mode == 'OBJECT':
            return 'Assign Material to all selected Objects'
        else:
            return 'Assign Material to all selected Faces'


    def draw(self, context):
        l = self.layout

        for material in bpy.data.materials:
            if material.preview:
                UI_OT_support_assign_material.create_ui(l, material.name, None, material.preview.icon_id, material)
            else:
                UI_OT_support_assign_material.create_ui(l, material.name, 'QUESTION', -1, material)


def node_editor_header(self, context: bpy.types.Context):
    """
    Add useful tools to shader editor header.
    """
    props = Properties.get()

    layout = self.layout # type: bpy.types.UILayout
    r = layout.row(align=True)
    #r.prop(props, 'show_material_replacer', toggle=True, text='', icon='OVERLAY')

    r.operator(UI_OT_support_arrange_nodes.bl_idname, text='', icon='AUTO')
    r.separator()

    m = context.material
    if m:
        # UI_OT_support_assign_material.create_ui(r, '', 'NODE_MATERIAL', -1, m)
        r.operator(UI_OT_support_fix_eevee_transparency.bl_idname, text='', icon='MOD_OPACITY')
        dc = r.row(align=True)
        dc.ui_units_x = 1
        dc.prop(m, 'diffuse_color', text='')    

        obj = context.active_object
        if obj:
            dc = r.row(align=True)
            dc.ui_units_x = 1
            dc.prop(obj, 'color', text='')    



def add_node_editor_header():
    bpy.types.NODE_HT_header.append(node_editor_header)


def remove_node_editor_header():
    bpy.types.NODE_HT_header.remove(node_editor_header)

