# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

from bpy.types import Menu

from ..registries.collections import Collections
from ..properties import Properties
from ..preferences import PreferencesPanel


class NODE_MT_snw_collection_pie_menu(Menu):
    """
    Displays all collection from a given group.
    TODO: Finalize, currently unused (planned for none-static collections).
    """
    bl_idname = "NODE_MT_snw_collection_pie_menu"
    bl_label = "Select Item"


    @classmethod
    def poll(cls, context):
        return context.space_data.type == 'NODE_EDITOR' and \
            context.space_data.node_tree is not None  and \
            context.space_data.tree_type == 'ShaderNodeTree'    


    def draw(self, context):
        pie = self.layout.menu_pie()
        pie.separator()

        props = Properties.get()
        c = pie.box().grid_flow(columns=PreferencesPanel.get().preview_columns_pie, row_major=True, align=True)
        for i in Collections.instance().collection(props.collection_group):
            b = c.box().column()
            b.template_icon(icon_value=i[0], scale=PreferencesPanel.get().preview_scale_pie)
