# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

from bpy.types import Menu

from ..snw.ui import insert_preview_update
from ..registries.texture_registry import RepositoryType, TextureRegistry
from ..operators.support_cascade_pie_menu import UI_OT_support_cascade_pie_menu
from ..properties import Properties
from ..preferences import PreferencesPanel


class NODE_MT_snw_grunge_category_pie_menu(Menu):
    """
    Pie Menu to select Grunge category.
    """
    bl_idname = "NODE_MT_snw_grunge_category_pie_menu"
    bl_label = "Select Grunge Category"


    @classmethod
    def poll(cls, context):
        return context.space_data.type == 'NODE_EDITOR' and \
            context.space_data.node_tree is not None  and \
            context.space_data.tree_type == 'ShaderNodeTree'    


    def draw(self, context):
        pie = self.layout.menu_pie()

        pie.separator()
        c = pie.column().grid_flow(columns=4, align=True)
        for t in TextureRegistry.instance().get_category_enums(RepositoryType.Gray):
            op = c.operator(UI_OT_support_cascade_pie_menu.bl_idname, text=t[1])
            op.mode = 'Grunge'
            op.param = t[0]


class NODE_MT_snw_grunge_pie_menu(Menu):
    """
    Displays all textures from a grunge/gray category and creates the Grunge material.
    """
    bl_idname = "NODE_MT_snw_grunge_pie_menu"
    bl_label = "Select Grunge"

    @classmethod
    def poll(cls, context):
        return context.space_data.type == 'NODE_EDITOR' and \
            context.space_data.node_tree is not None  and \
            context.space_data.tree_type == 'ShaderNodeTree'    


    def draw(self, context):
        pie = self.layout.menu_pie()
        pie.separator()

        props = Properties.get().grunge
        p = pie.column()
        entries = TextureRegistry.instance().get_image_list(RepositoryType.Gray, props.categories, with_preview=True)
        if entries:
            insert_preview_update(p.row(align=True), RepositoryType.Gray, props.categories)
            c = p.box().grid_flow(columns=PreferencesPanel.get().preview_columns_pie, row_major=True, align=True)
            for i in entries:
                b = c.box().column()
                b.template_icon(icon_value=i.preview_icon_id, scale=PreferencesPanel.get().preview_scale_pie)
                op = b.operator('snw.create_node_grunge_tex', text='Create', icon='NODE_COMPOSITING')
                op.category = props.categories
                op.grunge = i.key
                op.bin_hash = i.get_bin_hash()
        else:
            p.box().label(text='No content')

