# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

from bpy.types import Menu

from ..utils.blender import tool_mode_string
from ..snw.ui import insert_brush, insert_preview_update
from ..registries.texture_registry import RepositoryType, TextureRegistry
from ..registries.database import Database
from ..properties import Properties
from ..preferences import PreferencesPanel


class VIEW3D_MT_snw_brush_pie_menu(Menu):
    """
    Displays all textures from a brush category and selects the brush.
    """
    bl_idname = "VIEW3D_MT_snw_brush_pie_menu"
    bl_label = "Select Brush"


    @classmethod
    def poll(cls, context):
        return context.space_data.type == 'VIEW_3D' and (
            context.mode == 'PAINT_TEXTURE' or context.mode == 'SCULPT'
        )


    def draw(self, context):
        tool_mode = tool_mode_string(context
                                     )
        pie = self.layout.menu_pie()
        pie.separator()

        favourites = Database.instance().get_favourite_brushes()
        props = Properties.get().brush
        p = pie.column()
        entries = TextureRegistry.instance().get_image_list(RepositoryType.Brush, props.categories, with_preview=True)
        if entries:
            insert_preview_update(p.row(align=True), RepositoryType.Brush, props.categories)
            c = p.box().grid_flow(columns=PreferencesPanel.get().preview_columns_pie, row_major=True, align=True)
            for entry in entries:
                insert_brush(c, entry, True, entry.get_bin_hash() in favourites, tool_mode)
        else:
            p.box().label(text='No content')

