# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Menu

from ..snw.ui import insert_material_assign_menu, insert_vertex_color_panel


class VIEW3D_MT_snw_edit_mode_pie_menu(Menu):
    """
    The primary PIE menu for vertex colors in 3D, Edit mode, shown when hitting the primary addon button ('D').
    """
    bl_idname = "VIEW3D_MT_snw_edit_mode_pie_menu"
    bl_label = "Shader Node Wizard"


    @classmethod
    def poll(cls, context: bpy.types.Context):
        return context.space_data.type == 'VIEW_3D' and context.mode == 'EDIT_MESH'


    def draw(self, context):
        pie = self.layout.menu_pie()
        insert_vertex_color_panel(pie.row().column(align=True), context)
        insert_material_assign_menu(pie.row().column(align=True), context)

