# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Operator
from bpy.props import IntProperty, StringProperty

from ..utils.blender import drop_node
from ..registries.collections import Collections
from ..operators.helpers.drop_node import DropNodeOperator


class UI_OT_create_node_collection_item(DropNodeOperator, Operator):
    """
    Drop node from collection.
    """
    bl_idname = 'snw.create_ci_node'
    bl_label = 'Create'
    bl_description = 'Create a new collection item node'
    bl_options = {'REGISTER'}


    group: StringProperty() # type: ignore
    id: IntProperty() # type: ignore
    description: StringProperty() # type: ignore


    def execute(self, context: bpy.types.Context):
        nt = Collections.instance().load_item(self.group, self.id)
        if nt:
            return drop_node(nt)
        else:
            return {'FINISHED'}


    @classmethod
    def description(cls, context, properties):
        return properties.description