# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Operator
from bpy.props import StringProperty

from ..preferences import PreferencesPanel
from ..utils.blender import drop_node
from ..operators.helpers.setup_grunge import create_grunge, setup_grunge
from ..operators.helpers.drop_node import DropNodeOperator


class UI_OT_create_node_grunge_tex(DropNodeOperator, Operator):
    bl_idname = 'snw.create_node_grunge_tex'
    bl_label = 'Create'
    bl_description = 'Create a new Grunge node'
    bl_options = {'REGISTER'}


    category: StringProperty() # type: ignore
    grunge: StringProperty() # type: ignore
    bin_hash: StringProperty() # type: ignore


    def execute(self, context: bpy.types.Context):
        prefs = PreferencesPanel.get()

        nb = create_grunge(self.grunge, True)
        setup_grunge(
            nb, 
            self.category, 
            self.grunge, 
            self.bin_hash, 
            prefs.default_texture_mapping,
            interpolation=prefs.default_image_interpolation,
            bevel_samples=prefs.default_bevel_samples,
        )
        return drop_node(nb.tree)


    @classmethod
    def description(cls, context, properties):
        return properties.grunge        

       