# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Operator
from bpy.props import StringProperty

from ..utils.node_builder_cycles import NodeBuilderCycles
from ..utils.blender import drop_node
from ..operators.helpers.drop_node import DropNodeOperator


class UI_OT_create_node_mask(DropNodeOperator, Operator):
    """
    Used to drop AOE mask, initiated from side menu.
    """
    bl_idname = 'snw.create_node_mask'
    bl_label = 'Create Node'
    bl_description = 'Create node that outputs the individual channels of the baked texture'
    bl_options = {'REGISTER'}

    mask: StringProperty() # type: ignore
    mask_uv: StringProperty() # type: ignore

    def execute(self, context: bpy.types.Context):
        nb = NodeBuilderCycles()

        nb.build_node_tree(self.mask)
        nb.add_outputs([
            ( 'Float', 'AO Outside' ),
            ( 'Float', 'AO Inside' ),
            ( 'Float', 'Edge' ),
        ])

        rgb = nb.add_separate_rgb(
            image = nb.add_image(
                image=bpy.data.images[self.mask],
                vector=nb.add_uv_map(self.mask_uv).outputs[0]
            ).outputs[0]
        )

        nb.wire_sockets(rgb.outputs[0], nb.output('AO Outside'))
        nb.wire_sockets(rgb.outputs[1], nb.output('AO Inside'))
        nb.wire_sockets(rgb.outputs[2], nb.output('Edge'))

        nb.arrange()

        return drop_node(nb.tree)