# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Operator
from bpy.props import StringProperty, IntProperty

from ..preferences import PreferencesPanel
from ..utils.blender import drop_node
from ..operators.helpers.setup_pbr import create_pbr, setup_pbr
from ..operators.helpers.drop_node import DropNodeOperator


class UI_OT_create_node_pbr_material(DropNodeOperator, Operator):
    bl_idname = 'snw.create_pbr_node'
    bl_label = 'Create'
    bl_description = 'Create a new PBR node'
    bl_options = {'REGISTER'}

    category: StringProperty() # type: ignore
    pbr: StringProperty() # type: ignore
    variant: IntProperty() # type: ignore
    bin_hash: StringProperty() # type: ignore


    def execute(self, context: bpy.types.Context):
        prefs = PreferencesPanel.get()

        nb = create_pbr(self.pbr)
        setup_pbr(
            nb, 
            self.category, 
            self.pbr, 
            self.variant, 
            self.bin_hash, 
            prefs.default_texture_mapping,
            interpolation=prefs.default_image_interpolation,
            bevel_samples=prefs.default_bevel_samples,
        )
        return drop_node(nb.tree)


    @classmethod
    def description(cls, context, properties):
        return properties.pbr
