# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Operator, UILayout
from bpy.props import StringProperty

from ..operators.helpers.drop_node import DropNodeOperator
from ..registries.icons_registry import IconsRegistry

class UI_OT_create_node_std(DropNodeOperator, Operator):
    """
    Drops a standard Blender node, eventually set property to that node.
    """
    bl_idname = 'snw.create_node_std'
    bl_label = 'Create'
    bl_description = 'Create a new standard node'
    bl_options = {'REGISTER'}

    system: StringProperty() # type: ignore
    type: StringProperty() # type: ignore
    op: StringProperty() # type: ignore
    bt: StringProperty() # type: ignore
    tooltip: StringProperty() # type: ignore


    @classmethod
    def description(cls, context, properties):
        return properties.tooltip


    def execute(self, context: bpy.types.Context):
        settings = []
        if self.op: 
            settings.append({ 
                'name': 'operation',
                'value': self.op
            })
        if self.bt:
            settings.append({ 
                'name': 'blend_type',
                'value': self.bt
            })

        if settings:
            bpy.ops.node.add_node(
                type=f"{self.system}Node{self.type}", 
                use_transform=True,
                settings=settings
            )
        else:
            bpy.ops.node.add_node(
                type=f"{self.system}Node{self.type}", 
                use_transform=True,
            )

        return{'FINISHED'}


    @staticmethod
    def create_ui(l: UILayout, system: str, type: str, ope: str, bt: str, text: str, icon: str, tooptip: str, color: str = None):
        op = None # type: UI_OT_create_node_std
        if color and IconsRegistry.colored_icon_exists(icon, color):
            op = l.operator(UI_OT_create_node_std.bl_idname, text=text, icon_value=IconsRegistry.get_colored_icon(icon, color))         
        else:
            op = l.operator(UI_OT_create_node_std.bl_idname, text=text, icon=icon if icon else 'NONE')
        op.system = system
        op.type = type
        op.op = ope
        op.bt = bt
        op.tooltip = tooptip    
