# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Operator
from bpy.props import StringProperty

from ..utils.blender import drop_std_node
from ..operators.helpers.drop_node import DropNodeOperator

class UI_OT_create_node_uv_map(DropNodeOperator, Operator):
    """
    Called when creating new or dropping UVMap from PIE menu.
    """
    bl_idname = 'snw.create_node_uv_map'
    bl_label = ''
    bl_description = ''
    bl_options = {'REGISTER'}


    uv_map: StringProperty() # type: ignore


    def execute(self, context: bpy.types.Context):
        if len(self.uv_map) < 1:
            mp = context.active_object.data.uv_layers.new().name
        else:
            mp = self.uv_map

        return drop_std_node(
            'UVMap', 
            [
                {
                    'name': 'uv_map',
                    'value': f"'{mp}'"
                }
            ]
        )


    @classmethod
    def description(cls, context, properties):
        return 'Drop "UVMap" node with this map' if properties.uv_map else 'Create new UV map and drop "UVMap" node'
