# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Operator
from bpy.props import StringProperty

from ..properties import Properties

from ..utils.blender import drop_std_node
from ..operators.helpers.drop_node import DropNodeOperator


class UI_OT_create_vertex_colors(Operator):
    """
    Called from 3D header, adding new vertex color channel.
    """
    bl_idname = 'snw.create_vertex_colors'
    bl_label = ''
    bl_description = ''
    bl_options = {'REGISTER'}


    def execute(self, context: bpy.types.Context):
        cols = context.active_object.data.vertex_colors.new().name

        Properties.get().vertex_color_set = cols

        return {'FINISHED'}


class UI_OT_create_node_vertex_colors(DropNodeOperator, Operator):
    """
    Called when adding or dropping vertex color node from PIE menu.
    """
    bl_idname = 'snw.create_node_vertex_colors'
    bl_label = ''
    bl_description = ''
    bl_options = {'REGISTER'}


    cols: StringProperty() # type: ignore


    def execute(self, context: bpy.types.Context):
        if len(self.cols) < 1:
            cols = context.active_object.data.vertex_colors.new().name
        else:
            cols = self.cols

        return drop_std_node(
            'VertexColor', 
            [
                {
                    'name': 'layer_name',
                    'value': f"'{cols}'"
                }
            ]
        )


    @classmethod
    def description(cls, context, properties):
        return 'Drop "Color Attribute" node with this map' if properties.cols else 'Create new vertex colors and drop "Color Attribute" node'
