# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Operator
from bpy.props import StringProperty


class UI_OT_delete_element(Operator):
    """
    Called when clicking on remove UVmap or remove vertex color from PIE menu (Minus-button).
    """
    bl_idname = 'snw.delete_element'
    bl_label = ''
    bl_description = 'Remove this element'
    bl_options = {'REGISTER'}


    uv_map: StringProperty() # type: ignore
    vertex_colors: StringProperty() # type: ignore


    def execute(self, context: bpy.types.Context):
        if self.uv_map:
            layers = context.active_object.data.uv_layers
            layers.remove(layers[self.uv_map])
        elif self.vertex_colors:
            vc = context.active_object.data.vertex_colors
            vc.remove(vc[self.vertex_colors])

        return {'FINISHED'}