# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

from bpy.types import Operator
from bpy.props import IntProperty, StringProperty
from bpy_extras.io_utils import ImportHelper

from ..preferences import PreferencesPanel


class UI_OT_support_add_texture_directory(Operator, ImportHelper):
    """
    Used in preferences to add a new texture directory, either PBR or grunge.
    """
    bl_idname = 'snw.support_add_texture_directory'
    bl_label = 'Add texture directory'
    bl_description = 'Add texture directory'
    bl_options = {'REGISTER'}


    directory = StringProperty(subtype='DIR_PATH')
    style: IntProperty(options={'HIDDEN'}) # type: ignore


    def execute(self, context):
        PreferencesPanel.add_texture_directory(self.filepath, self.style)

        return {'FINISHED'}

