# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Operator

from ..utils.node_builder import NodeBuilder


class UI_OT_support_arrange_nodes(Operator):
    """
    Called to arrange node in shader editor.
    """
    bl_idname = 'snw.support_arrange_nodes'
    bl_label = 'Arrange Nodes'
    bl_description = 'Arrange / auto position nodes in shader graph'
    bl_options = {'REGISTER', 'UNDO'}


    @classmethod
    def poll(cls, context):
        return context.space_data.type == 'NODE_EDITOR' and \
            context.space_data.node_tree is not None and \
            context.space_data.tree_type == 'ShaderNodeTree'


    def execute(self, context: bpy.types.Context):
        nb = NodeBuilder()
        nb.tree = context.space_data.edit_tree
        if nb.tree:
            nb.arrange() 

        return{'FINISHED'}
    