# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

from bpy.types import Operator
from bpy.props import StringProperty

from ..properties import Properties


class UI_OT_support_bake_quick_setup(Operator):
    """
    Fills bake properties with predefined constant values.
    """
    bl_idname = 'snw.support_bake_quick_setup'
    bl_label = 'Quick setups for baking'
    bl_description = 'Default setups for baking'
    bl_options = {'REGISTER'}    

    setup: StringProperty() # type: ignore


    def execute(self, context):
        if self.setup == 'quick': s = [ '256', 4, 2, 8, False ]
        elif self.setup == 'preview': s = [ '512', 16, 4, 16, True ]
        else: s = [ '2048', 64, 16, 128, True ]

        p = Properties.get() # type: Properties
        p.bake_size = s[0]
        p.bake_ao_samples = s[1]
        p.bake_bevel_samples = s[2]
        p.bake_cycles_samples = s[3]
        p.bake_post_blur = s[4]

        return {'FINISHED'}
        