# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Operator
from bpy.props import StringProperty

from ..properties import Properties


class UI_OT_support_cascade_pie_menu(Operator):
    """
    Called as op from higher pie menu to switch to the next level.
    """
    bl_idname = 'snw.support_cascade_pie_menu'
    bl_label = 'Cascade Pie Menu'
    bl_description = 'Switch to next pie menu level'
    bl_options = {'REGISTER'}

    mode: StringProperty() # type: ignore
    param: StringProperty() # type: ignore


    def execute(self, context: bpy.types.Context):
        if self.mode == 'PBR':
            Properties.get().pbr.categories = self.param
            bpy.ops.wm.call_menu_pie(name='NODE_MT_snw_pbr_set_pie_menu')
        elif self.mode == 'Image':
            Properties.get().image.categories = self.param
            bpy.ops.wm.call_menu_pie(name='NODE_MT_snw_image_pie_menu')
        elif self.mode == 'Grunge':
            Properties.get().grunge.categories = self.param
            bpy.ops.wm.call_menu_pie(name='NODE_MT_snw_grunge_pie_menu')
        elif self.mode == 'Brush':
            Properties.get().brush.categories = self.param
            bpy.ops.wm.call_menu_pie(name='VIEW3D_MT_snw_brush_pie_menu')
        elif self.mode == 'Collection':
            Properties.get().collection_group = self.param
            bpy.ops.wm.call_menu_pie(name='NODE_MT_snw_collection_pie_menu')

        return{'FINISHED'}


    @classmethod
    def description(cls, context, properties):
        return {
            'PBR': 'Cascade to PBR selection and create and drop PBR node',
            'Grunge': 'Cascade to Grunge selection and create and drop Grunge node',
            'Collection': 'Cascade to user collection and drop node',
        }.get(properties.mode, '??')

        