# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Operator

class UI_OT_support_fix_eevee_transparency(Operator):
    """
    Placed in the shader editor header, setup material, so
    eevee shows a transparent material correctly.
    """
    bl_idname = 'snw.support_fix_eevee_transparency'
    bl_label = 'Fix Eevee Transparency'
    bl_description = 'Set material params, so transparency works good in Eevee'
    bl_options = {'REGISTER'}


    def execute(self, context: bpy.types.Context):
        material = context.material # type: bpy.types.Material
        material.show_transparent_back = False
        material.blend_method = 'BLEND'
        material.shadow_method = 'CLIP'
        material.use_screen_refraction = True

        return{'FINISHED'}
