# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Operator
from bpy.props import IntProperty, StringProperty, BoolProperty

from ..registries.texture_registry import TextureRegistry


class UI_OT_support_generate_previews(Operator):
    """
    Called if create/update preview images of a PBR/gray category is started.
    """
    bl_idname = 'snw.support_generate_previews'
    bl_label = 'Create / Update ALL Previews'
    bl_description = 'Create / Update all previews for current category'
    bl_options = {'REGISTER'}

    repository_type: IntProperty() # type: ignore
    category: StringProperty() # type: ignore
    missing_only: BoolProperty() # type: ignore
    size: IntProperty() # type: ignore
    

    def execute(self, context: bpy.types.Context):
        TextureRegistry.instance().create_update_previews(self.repository_type, self.category, self.missing_only, self.size)
        return{'FINISHED'}
