# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

from bpy.types import Operator
from bpy.props import StringProperty

from ..preferences import PreferencesPanel


class UI_OT_support_manage_texture_directory(Operator):
    """
    Handles recan and remove texture repository.
    """
    bl_idname = 'snw.support_manage_texture_directory'
    bl_label = 'Manage texture directory'
    bl_description = 'Remove texture directory'
    bl_options = {'REGISTER'}


    mode: StringProperty() # type: ignore
    path: StringProperty() # type: ignore


    def execute(self, context):
        if self.mode == 'remove':
            PreferencesPanel.remove_texture_directory(self.path)
        elif self.mode == 'rescan':
            PreferencesPanel.rescan_texture_directory(self.path)

        return {'FINISHED'}


    @classmethod
    def description(cls, context, properties):
        return {
            'remove': 'Remove texture directory',
            'rescan': 'Rescan texture directory',
        }.get(properties.mode, '??')

