# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Operator, UILayout
from bpy.props import StringProperty

from ..preferences import PreferencesPanel
from ..properties import Properties
from ..registries.icons_registry import IconsRegistry
from ..utils.tools import local_addon_info


class UI_OT_multi_purpose(Operator):
    """
    Agree initial notice.
    """
    bl_idname = 'snw.multi_purpose'
    bl_label = ''
    bl_description = ''
    bl_options = {'REGISTER', 'UNDO'}


    mode: StringProperty(options={'HIDDEN'}) # type: ignore
    param0: StringProperty(options={'HIDDEN'}) # type: ignore


    @classmethod
    def description(cls, context, properties):
        return {
            'xt': 'Extend Trial by 24h',
            'buy_g': 'Purchase Shader Node Wizard on Gumroad',
            'buy_s': 'Purchase Shader Node Wizard on SuperHive',
            'buy_b_g': 'Purchase Bundle on Gumroad',
            'buy_b_s': 'Purchase Bundle on SuperHive',
        }.get(properties.mode, '??')


    def execute(self, context: bpy.types.Context):
        prefs = PreferencesPanel.get()
        props = Properties.get()
        if self.mode == 'xt':
            local_addon_info.dxp()
        elif self.mode == 'buy_g':
            bpy.ops.wm.url_open(url="https://h0bb1t.gumroad.com/l/ipgrv")
        elif self.mode == 'buy_s':
            bpy.ops.wm.url_open(url="https://superhivemarket.com/products/shader-node-wizard")
        elif self.mode == 'buy_b_g':
            bpy.ops.wm.url_open(url="https://h0bb1t.gumroad.com/l/wab")
        elif self.mode == 'buy_b_s':
            bpy.ops.wm.url_open(url="https://superhivemarket.com/products/wizard-addon-bundle")

        return {'FINISHED'}


    @staticmethod
    def create_ui(l: UILayout, mode: str, text: str, icon: str, param0: str = '', color: str = None):
        op = None # type: UI_OT_multi_purpose
        if color and IconsRegistry.colored_icon_exists(icon, color):
            op = l.operator(UI_OT_multi_purpose.bl_idname, text=text, icon_value=IconsRegistry.get_colored_icon(icon, color)) 
        else:    
            op = l.operator(UI_OT_multi_purpose.bl_idname, text=text, icon=icon if icon else 'NONE')
        op.mode = mode
        op.param0 = param0
        return op


    @staticmethod
    def create_ui_buy(l: UILayout, x: bool):
        box = l.box()
        box.label(text="Best value — Bundle incl. Asset Wizard Pro:")
        row = box.row(align=True)
        UI_OT_multi_purpose.create_ui(row, 'buy_b_g', 'Gumroad', 'URL')
        UI_OT_multi_purpose.create_ui(row, 'buy_b_s', 'SuperHive', 'URL')
        box.label(text="Save ~20% vs. individual tools.", icon='INFO')

        l.separator()

        box = l.box()
        box.label(text="Or get a single license:")
        row = box.row(align=True)
        UI_OT_multi_purpose.create_ui(row, 'buy_g', 'Gumroad', 'URL')
        UI_OT_multi_purpose.create_ui(row, 'buy_s', 'SuperHive', 'URL')

        l.separator()

        if x:
            box = l.box()
            box.label(text="Need more time?")
            UI_OT_multi_purpose.create_ui(box, 'xt', 'Extend 24h', 'RECOVER_LAST')

