# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Operator
from bpy.props import StringProperty


class UI_OT_support_paint_command(Operator):
    """
    Called to switch to other texture to paint on or exit texture paint.
    """
    bl_idname = 'snw.support_paint_command'
    bl_label = ''
    bl_description = 'Remove this element'
    bl_options = {'REGISTER'}

    mode: StringProperty() # type: ignore
    image: StringProperty() # type: ignore
    uv_map: StringProperty() # type: ignore


    def execute(self, context: bpy.types.Context):
        if self.mode == 'EXIT':
            bpy.ops.paint.texture_paint_toggle()
        elif self.mode == 'SET_IMAGE':
            image = bpy.data.images[self.image]
            obj = context.active_object
            data = obj.data

            if context.mode != 'PAINT_TEXTURE':
                bpy.ops.paint.texture_paint_toggle()
                
            context.tool_settings.image_paint.mode = 'IMAGE'
            context.tool_settings.image_paint.canvas = image

            # Select correct texture.

            mat = obj.active_material
            idx = mat.texture_paint_images.find(self.image)
            if idx >= 0:
                mat.paint_active_slot = idx

            # Select matching UV Map.
            data.uv_layers.active = data.uv_layers[self.uv_map]


        return {'FINISHED'}