# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Panel

from ..properties import Properties

from ..utils.tools import local_addon_info

from ..operators.support_mask_bake import UI_OT_support_mask_bake
from ..operators.support_quick_uv_unwrap import UI_OT_support_quick_uv_unwrap
from ..operators.support_bake_quick_setup import UI_OT_support_bake_quick_setup
from ..operators.create_node_mask import UI_OT_create_node_mask


class NODE_PT_snw_side_panel_bake_aoe(Panel):
    bl_label = 'Bake AOE Map'
    bl_idname = 'NODE_PT_snw_side_panel_bake_aoe'
    bl_space_type = 'NODE_EDITOR'
    bl_region_type = 'UI'
    bl_category = 'Shader Node Wizard'


    @classmethod
    def poll(cls, context):
        return context.space_data.type == 'NODE_EDITOR' and \
            context.space_data.node_tree is not None  and \
            context.space_data.tree_type == 'ShaderNodeTree' and \
            local_addon_info.vl()


    def draw(self, context):
        layout = self.layout
        props = Properties.get() # Properties

        uv_set_name = 'UVMap SNW'

        o = context.active_object
        if o and o.type == 'MESH':
            m = layout
            c = m.column(align=True)
            r = c.row(align=True)
            r.operator(UI_OT_support_bake_quick_setup.bl_idname, text='Quick').setup = 'quick'
            r.operator(UI_OT_support_bake_quick_setup.bl_idname, text='Preview').setup = 'preview'
            r.operator(UI_OT_support_bake_quick_setup.bl_idname, text='Final').setup = 'final'
            c.row(align=True).prop(props, 'bake_size', expand=True)
            c.prop(props, 'bake_uv_gen_margin_auto', toggle=True, icon='TRACKING_CLEAR_FORWARDS')
            auto_margin = (props.bake_bake_margin + 1) / int(props.bake_size)
            if not props.bake_uv_gen_margin_auto:
                c.prop(props, 'bake_uv_gen_margin', slider=True)
            else:
                c.label(text=f'Margin: {auto_margin:.3f}')

            c = m.column(align=True)    
            op = c.operator(UI_OT_support_quick_uv_unwrap.bl_idname, icon='UV')
            op.uv_set = uv_set_name
            if not props.bake_uv_gen_margin_auto:
                op.margin = props.bake_uv_gen_margin
            else:
                op.margin = auto_margin

            c = m.column(align=True)
            c.prop(props, 'bake_ao_samples', slider=True)
            c.prop(props, 'bake_ao_distance')
            c.prop(props, 'bake_bevel_samples', slider=True)
            c.prop(props, 'bake_bevel_distance')        
            c.prop(props, 'bake_cycles_samples')
            c.prop(props, 'bake_bake_margin', slider=True)
            c.prop(props, 'bake_cycles_denoise', toggle=True, icon='MOD_UVPROJECT')
            c.prop(props, 'bake_post_blur', toggle=True, icon='ANTIALIASED')
            c.prop(props, 'bake_disable_modifiers', toggle=True, icon='MODIFIER')

            mask_image_name = f'{o.name}_aoe_mask'
            c = m.column(align=True) 
            op = c.operator(UI_OT_support_mask_bake.bl_idname, icon='RENDER_STILL') # type: UI_OT_support_mask_bake
            op.image = mask_image_name
            op.resolution = int(props.bake_size)
            op.uv_set = uv_set_name
            op.ao_samples = props.bake_ao_samples
            op.ao_distance = props.bake_ao_distance
            op.bevel_samples = props.bake_bevel_samples
            op.bevel_distance = props.bake_bevel_distance
            op.cycles_samples = props.bake_cycles_samples
            op.cycles_denoise = props.bake_cycles_denoise
            op.bake_margin = props.bake_bake_margin
            op.post_blur = props.bake_post_blur
            op.disable_modifiers = props.bake_disable_modifiers

            if mask_image_name in bpy.data.images and uv_set_name in o.data.uv_layers:
                op = c.operator(UI_OT_create_node_mask.bl_idname, icon='HOLDOUT_ON') #type: UI_OT_create_node_mask
                op.mask = mask_image_name
                op.mask_uv = uv_set_name
