# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

from bpy.types import Panel

from ..snw.ui import insert_category_and_preview
from ..properties import Properties
from ..utils.tools import local_addon_info
from ..operators.create_node_pbr_map import UI_OT_create_pbr_map
from ..registries.texture_registry import RepositoryType, TextureRegistry
from ..preferences import PreferencesPanel

class NODE_PT_snw_side_panel_create_pbr_map(Panel):
    bl_label = 'Create PBR Map'
    bl_idname = 'NODE_PT_snw_side_panel_create_pbr_map'
    bl_space_type = 'NODE_EDITOR'
    bl_region_type = 'UI'
    bl_category = 'Shader Node Wizard'


    @classmethod
    def poll(cls, context):
        return context.space_data.type == 'NODE_EDITOR' and \
            context.space_data.node_tree is not None  and \
            context.space_data.tree_type == 'ShaderNodeTree' and \
            local_addon_info.vl()


    def draw(self, context):
        layout = self.layout
        props = Properties.get() # Properties

        m = layout
        c = m.column(align=True)
        insert_category_and_preview(
            c,
            PreferencesPanel.get().preview_scale_side,
            PreferencesPanel.get().preview_scale_side_popup,
            props.pbr_mask_map
        )
        if props.pbr_mask_map.get_categories() and props.pbr_mask_map.get_previews():
            current_pbr_img = TextureRegistry.instance().get_image(
                RepositoryType.PBR,
                props.pbr_mask_map.categories,
                props.pbr_mask_map.previews,
            )
            if current_pbr_img:
                current_pbr = current_pbr_img.info.pbr

                if not current_pbr.metal:
                    c.prop(props, 'pbr_mask_metallic_default', slider=True)
                if not current_pbr.specular:
                    c.prop(props, 'pbr_mask_specular_default', slider=True)
                if not current_pbr.roughness and not current_pbr.glossiness:
                    c.prop(props, 'pbr_mask_roughness_default', slider=True)
                c.prop(props, 'pbr_mask_colors', slider=True)
                c.prop(props, 'pbr_mask_max_cluster_size', slider=True)
                c.prop(props, 'pbr_mask_order')

                c = m.column(align=True)
                op = c.operator(UI_OT_create_pbr_map.bl_idname, icon='NODE_TEXTURE') # type: UI_OT_create_pbr_map
                op.name = current_pbr.name
                op.diffuse = current_pbr.diffuse
                op.metallic = current_pbr.metal if current_pbr.metal else ''
                op.specular = current_pbr.specular if current_pbr.specular else ''
                op.roughness = current_pbr.roughness if current_pbr.roughness else ''
                op.glossiness = current_pbr.glossiness if current_pbr.glossiness else ''
                op.metallic_const = props.pbr_mask_metallic_default               
                op.specular_const = props.pbr_mask_specular_default
                op.roughness_const = props.pbr_mask_roughness_default
                op.colors = props.pbr_mask_colors
                op.max_cluster_size = props.pbr_mask_max_cluster_size
                op.order = props.pbr_mask_order
        else:
            c.label(text='No PBR categories found')

