# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Panel

from ..utils.tools import local_addon_info
from ..snw.ui import trial_panel


class NODE_PT_side_panl_info(Panel):
    """
    Show info panel.
    """
    bl_label = 'Info'
    bl_idname = 'NODE_PT_snw_side_panel_info'
    bl_space_type = 'NODE_EDITOR'
    bl_region_type = 'UI'
    bl_category = 'Shader Node Wizard'


    @classmethod
    def poll(cls, context):
        return context.space_data.type == 'NODE_EDITOR' and \
            context.space_data.node_tree is not None  and \
            context.space_data.tree_type == 'ShaderNodeTree' and \
            not local_addon_info.vl()


    def draw(self, context: bpy.types.Context):
        trial_panel(self.layout)
