# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

from bpy.types import Panel

from ..properties import Properties
from ..preferences import PreferencesPanel
from ..snw.ui import insert_category_and_preview, insert_preview_update
from ..utils.tools import local_addon_info
from ..registries.texture_registry import RepositoryType


class NODE_PT_snw_side_panel_manage_repositories(Panel):
    bl_label = 'Manage Repositories'
    bl_idname = 'NODE_PT_snw_side_panel_manage_repositories'
    bl_space_type = 'NODE_EDITOR'
    bl_region_type = 'UI'
    bl_category = 'Shader Node Wizard'
    bl_options = {'DEFAULT_CLOSED'}


    @classmethod
    def poll(cls, context):
        return context.space_data.type == 'NODE_EDITOR' and \
            context.space_data.node_tree is not None  and \
            context.space_data.tree_type == 'ShaderNodeTree' and \
            local_addon_info.vl()


    def draw(self, context):
        layout = self.layout
        props = Properties.get()
        
        c = layout.box().column(align=True)
        insert_category_and_preview(
            c,
            PreferencesPanel.get().preview_scale_side, 
            PreferencesPanel.get().preview_scale_side_popup,
            props.pbr_manage
        )
        if props.pbr_manage.get_categories() and props.pbr_manage.get_previews():
            insert_preview_update(c, RepositoryType.PBR, props.pbr_manage.categories)

        c = layout.box().column(align=True)
        insert_category_and_preview(
            c,
            PreferencesPanel.get().preview_scale_side, 
            PreferencesPanel.get().preview_scale_side_popup,
            props.image_manage
        )
        if props.image_manage.get_categories() and props.image_manage.get_previews():
            insert_preview_update(c, RepositoryType.Image, props.image_manage.categories)

        c = layout.box().column(align=True)
        insert_category_and_preview(
            c,
            PreferencesPanel.get().preview_scale_side, 
            PreferencesPanel.get().preview_scale_side_popup,
            props.grunge_manage
        )
        if props.grunge_manage.get_categories() and props.grunge_manage.get_previews():
            insert_preview_update(c, RepositoryType.Gray, props.grunge_manage.categories)

        c = layout.box().column(align=True)
        insert_category_and_preview(
            c,
            PreferencesPanel.get().preview_scale_side, 
            PreferencesPanel.get().preview_scale_side_popup,
            props.brush_manage
        )
        if props.brush_manage.get_categories() and props.brush_manage.get_previews():
            insert_preview_update(c, RepositoryType.Brush, props.brush_manage.categories)

        for path, _, _ in PreferencesPanel.get_texture_dirs():
            r = layout.box().row(align=True)
            r.label(text=path)
            op = r.operator('snw.support_manage_texture_directory', text='', icon='FILE_REFRESH')
            op.mode = 'rescan'
            op.path = path

