# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Panel

from ..operators.support_assign_material import UI_OT_support_assign_material
from ..properties import Properties
from ..utils.tools import local_addon_info


class NODE_PT_snw_side_panel_tools(Panel):
    bl_label = 'Tools'
    bl_idname = 'NODE_PT_snw_side_panel_tools'
    bl_space_type = 'NODE_EDITOR'
    bl_region_type = 'UI'
    bl_category = 'Shader Node Wizard'


    @classmethod
    def poll(cls, context):
        return context.space_data.type == 'NODE_EDITOR' and \
            context.space_data.node_tree is not None  and \
            context.space_data.tree_type == 'ShaderNodeTree' and \
            local_addon_info.vl()


    def draw(self, context: bpy.types.Context):
        props = Properties.get() # Properties

        l = self.layout.column(align=True)
        l.label(text='Replace all Instances of')
        l.prop(props, 'source_material_back', text='')
        l.label(text='   with')
        l.prop(props, 'replacement_material_back', text='')
        UI_OT_support_assign_material.create_ui_replace(
            l,
            'Replace',
            'MOD_MASK',
            props.source_material,
            props.replacement_material
        )
