# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import bpy

from bpy.types import Panel

from ..snw.ui import insert_vertex_color_panel
from ..utils.tools import local_addon_info


class NODE_PT_snw_side_panel_vertex_colors(Panel):
    bl_label = 'Vertex Colors'
    bl_idname = 'NODE_PT_snw_side_panel_vertex_colors'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = 'Shader Node Wizard'


    @classmethod
    def poll(cls, context):
        return context.space_data.type == 'VIEW_3D' and context.mode == 'EDIT_MESH' and \
            local_addon_info.vl()


    def draw(self, context: bpy.types.Context):
        insert_vertex_color_panel(self.layout.column(align=True), context)
