# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

from typing import Tuple

from bpy.types import NodeSocket, Image

from ..scanners.gray_entry import GrayEntry
from ....utils.blender import find_or_load_image
from ....utils.node_builder_cycles import NodeBuilderCycles

def build_gray_node_setup(
    nb: NodeBuilderCycles,
    gray: GrayEntry,
    uv: NodeSocket,
    mapping: str,
    blend: float,
    interpolation: str,
    ) -> Tuple[NodeSocket, Image]:
    """
    Uniquely setup the Gray entry into the given node tree.
    """
    image = find_or_load_image(gray.image)

    tx = nb.add_image(
        image, 
        colorspace='Non-Color',
        projection=mapping,
        blend=blend,
        vector=uv,
        interpolation=interpolation
    )

    if gray.channel < 0:
        socket = tx.outputs[0]
    else:
        if gray.channel == 3:
            socket = tx.outputs[1]
        else:
            spl = nb.add_separate_rgb(image=tx.outputs[0])
            socket = {
                0: spl.outputs['R'],
                1: spl.outputs['G'],
                2: spl.outputs['B'],
            }[gray.channel]

    return (socket, image)