# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

from typing import Tuple

from bpy.types import NodeSocket, Image

from ..scanners.image_entry import ImageEntry
from ....utils.blender import find_or_load_image
from ....utils.node_builder_cycles import NodeBuilderCycles

def build_image_node_setup(
    nb: NodeBuilderCycles,
    image: ImageEntry,
    uv: NodeSocket,
    mapping: str,
    blend: float,
    interpolation: str,
    ) -> Tuple[NodeSocket, NodeSocket, Image]:
    """
    Uniquely setup the Image entry into the given node tree.
    """
    image = find_or_load_image(image.image)

    tx = nb.add_image(
        image, 
        colorspace='sRGB',
        projection=mapping,
        blend=blend,
        vector=uv,
        interpolation=interpolation
    )

    return (tx.outputs[0], tx.outputs[1] , image)