# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

from typing import List, Union

from .brush_directory import BrushDirectory
from .gray_directory import GrayDirectory
from .pbr_directory import PBRDirectory
from .image_directory import ImageDirectory

class AbstractScanner:

    @staticmethod
    def flatten(
        dir: Union[BrushDirectory, GrayDirectory, PBRDirectory, ImageDirectory],
        target: List[Union[BrushDirectory, GrayDirectory, PBRDirectory, ImageDirectory]],
        parents: List[str],
        skip_append: bool
        ):
        """
        Helper to flatten tree to a linear list.
        """
        # Adjust name.
        p = parents.copy()
        if not skip_append:
            p.append(dir.name)

        if p or dir.has_sets():
            dir.name = '/'.join(p)
            if not dir.name: dir.name = '<ROOT>'
            target.append(dir)
        for d in dir.subdirs:
            AbstractScanner.flatten(d, target, p, False)

