# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

from dataclasses import dataclass, field
from typing import List

from .brush_entry import BrushEntry

@dataclass
class BrushDirectory:
    name: str
    path: str
    subdirs: List['BrushDirectory'] = field(default_factory=list)
    entries: List[BrushEntry] = field(default_factory=list)


    def empty(self) -> bool:
        """
        True if no subdirs and no files.
        """
        return not self.subdirs and not self.entries


    def has_sets(self) -> bool:
        """
        Has at least one set?
        """
        return len(self.entries) > 0   
        