# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

from dataclasses import dataclass
from typing import Dict


@dataclass
class BrushEntry:
    name: str
    preview: str = None

    image: str = None

    @staticmethod
    def load(data: Dict) -> 'BrushEntry':
        return BrushEntry(
            data.get('name'),
            data.get('preview'),
            data.get('image')
        )

    def save(self) -> Dict:
        return {
            'name': self.name,
            'preview': self.preview,
            'image': self.image
        }    