# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

import os

from typing import List

from .pbr_directory import PBRDirectory
from .extreme_pbr_scanner_vault import PBRExtremeScannerVault
from .extreme_pbr_scanner_old import PBRExtremeScannerOld


class PBRExtremeScanner:
    """
    Scan PBR sets from ExtremePBR directory.
    """
    @staticmethod
    def scan(path: str) -> List[PBRDirectory]:
        if os.path.exists(os.path.join(path, '._data')):
            return PBRExtremeScannerVault.scan(path)
        else:
            return PBRExtremeScannerOld.scan(path)
