# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

from dataclasses import dataclass
from typing import Dict


@dataclass
class GrayEntry:
    name: str
    preview: str = None

    image: str = None
    channel: int = -1

    @staticmethod
    def load(data: Dict) -> 'GrayEntry':
        return GrayEntry(
            data.get('name'),
            data.get('preview'),
            data.get('image'),
            data.get('channel')
        )

    def save(self) -> Dict:
        return {
            'name': self.name,
            'preview': self.preview,
            'image': self.image,
            'channel': self.channel
        }