# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.


class RepositoryType:
    PBR = 1     # Scan path for PBR sets
    Gray = 2    # Scan path for gray images
    Brush = 3   # Brushes for painting
    Image = 4   # Scan path for general images


class TextureType:
    PBRSet = 1  # Texture entry is PBR set
    Gray1 = 2   # Texture entry is single gray files
    Gray4 = 3   # Texture entry is RGBA, were each channel contains a gray image
    Brush = 4   # Brush for painting
    Image = 5   # Image texture

TEXTURE_PATH_GRUNGE = 0
TEXTURE_PATH_PBR = 10
TEXTURE_PATH_EXTREME_PBR = 11
TEXTURE_PATH_BRUSH_GRAY = 20
TEXTURE_PATH_IMAGE = 30

def texture_path_style_name(style: int) -> str:
    return {
        TEXTURE_PATH_GRUNGE: 'Grunge folder',
        TEXTURE_PATH_PBR: 'PBR folder',
        TEXTURE_PATH_EXTREME_PBR: 'ExtremePBR folder',
        TEXTURE_PATH_BRUSH_GRAY: 'Brushes folder',
        TEXTURE_PATH_IMAGE: 'Images folder'
    }.get(style, 'UNKNOWN')
